import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/url_container.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/controller/savings/savings_controller.dart';
import 'package:viserpay/data/model/savings/organaization_list_response_model.dart';
import 'package:viserpay/view/components/animated_widget/expanded_widget.dart';
import 'package:viserpay/view/components/column_widget/card_column.dart';
import 'package:viserpay/view/components/divider/custom_divider.dart';
import 'package:viserpay/view/components/image/my_image_widget.dart';

class DpsBankWidget extends StatelessWidget {
  final DpsPlan dps;
  const DpsBankWidget({super.key, required this.dps});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SavingsController>(
      builder: (controller) {
        return Container(
          padding: EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space10),
          decoration: BoxDecoration(
            color: MyColor.colorWhite,
            borderRadius: BorderRadius.circular(Dimensions.largeRadius),
            border: Border.all(color: MyColor.borderColor, width: 1),
            boxShadow: MyUtils.getCardShadow(),
          ),
          child: Column(
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Expanded(
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyImageWidget(
                          imageUrl: "${UrlContainer.domainUrl}/${controller.organizationImagePath}/${controller.selectedOrganization?.image}",
                          radius: 30,
                          height: 60,
                          width: 60,
                        ),
                        const SizedBox(width: Dimensions.space10),
                        Expanded(child: Text(controller.selectedOrganization?.name ?? "", style: semiBoldDefault.copyWith())),
                      ],
                    ),
                  ),
                  Radio(
                    value: controller.selectedDpsPlan?.id,
                    groupValue: dps.id,
                    activeColor: MyColor.primaryColor,
                    fillColor: WidgetStateProperty.all(MyColor.primaryColor),
                    onChanged: (value) {
                      controller.selectDpsPlan(dps);
                    },
                    materialTapTargetSize: MaterialTapTargetSize.padded,
                  ),
                ],
              ),
              const SizedBox(height: Dimensions.space10),
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  CardColumn(
                    header: MyStrings.installment,
                    body: "${controller.currencySym}${StringConverter.formatNumber(dps.installmentAmount ?? "", precision: 1)}",
                    headerTextStyle: boldDefault.copyWith(fontSize: Dimensions.fontLarge - 1, fontWeight: FontWeight.w500),
                    bodyTextStyle: lightMediumLarge.copyWith(color: MyColor.getGreyText()),
                  ),
                  CardColumn(
                    header: MyStrings.interest,
                    body: "${StringConverter.formatNumber(dps.interestRate ?? "", precision: 2)}%",
                    headerTextStyle: boldDefault.copyWith(fontSize: Dimensions.fontLarge - 1, fontWeight: FontWeight.w500),
                    bodyTextStyle: lightMediumLarge.copyWith(color: MyColor.getGreyText()),
                  ),
                  CardColumn(
                    header: MyStrings.tenure,
                    body: controller.selectedTenure?.name ?? "",
                    headerTextStyle: boldDefault.copyWith(fontSize: Dimensions.fontLarge - 1, fontWeight: FontWeight.w500),
                    bodyTextStyle: lightMediumLarge.copyWith(color: MyColor.getGreyText()),
                    alignmentEnd: true,
                  ),
                ],
              ),
              const SizedBox(height: Dimensions.space10),
              ExpandedSection(
                expand: controller.selectedDpsPlan?.id == dps.id,
                child: Column(
                  children: [
                    customRow(
                      title: MyStrings.maturityAmount,
                      value: "${controller.currencySym}${StringConverter.formatNumber(dps.maturityAmount ?? "", precision: 2)} ${controller.currency}",
                      valueTextStyle: lightDefault.copyWith(fontSize: Dimensions.fontLarge - 1, color: MyColor.greenSuccessColor),
                    ),
                    customRow(
                      title: MyStrings.penaltyRate,
                      value: "${StringConverter.formatNumber(dps.penaltyRate ?? "", precision: 2)}%",
                      showDivider: false,
                      valueTextStyle: lightDefault.copyWith(fontSize: Dimensions.fontLarge - 1, color: MyColor.redCancelTextColor),
                    ),
                    const SizedBox(height: Dimensions.space10),
                  ],
                ),
              )
            ],
          ),
        );
      },
    );
  }

  Widget customRow({required String title, required String value, bool showDivider = true, TextStyle? valueTextStyle}) {
    return Column(
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text(title, style: semiBoldDefault.copyWith(fontSize: Dimensions.fontLarge - 1)),
            Text(value, style: valueTextStyle ?? lightDefault.copyWith(fontSize: Dimensions.fontLarge - 1, color: MyColor.bodyTextColor)),
          ],
        ),
        if (showDivider) CustomDivider(onlyBottom: true),
      ],
    );
  }
}
